/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import java.io.IOException;
import org.htmlunit.BrowserVersion;
import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.XHtmlPage;
import org.wetator.backend.htmlunit.util.IThrowingConsumer;

public final class PageUtil {
    public static void consumeHtmlPage(String anHtmlCode, IThrowingConsumer<HtmlPage> aPageConsumer) throws IOException {
        PageUtil.consumeHtmlPage(BrowserVersion.FIREFOX_ESR, anHtmlCode, aPageConsumer);
    }

    public static void consumeHtmlPage(BrowserVersion aBrowserVersion, String anHtmlCode, IThrowingConsumer<HtmlPage> aPageConsumer) throws IOException {
        try (WebClient tmpWebClient = new WebClient(aBrowserVersion);){
            HtmlPage tmpPage = tmpWebClient.loadHtmlCodeIntoCurrentWindow(anHtmlCode);
            aPageConsumer.accept(tmpPage);
        }
    }

    public static void consumeXHtmlPage(String anXHtmlCode, IThrowingConsumer<XHtmlPage> aPageConsumer) throws IOException {
        PageUtil.consumeXHtmlPage(BrowserVersion.getDefault(), anXHtmlCode, aPageConsumer);
    }

    public static void consumeXHtmlPage(BrowserVersion aBrowserVersion, String anXHtmlCode, IThrowingConsumer<XHtmlPage> aPageConsumer) throws IOException {
        try (WebClient tmpWebClient = new WebClient(aBrowserVersion);){
            XHtmlPage tmpPage = tmpWebClient.loadXHtmlCodeIntoCurrentWindow(anXHtmlCode);
            aPageConsumer.accept(tmpPage);
        }
    }

    private PageUtil() {
    }
}

