/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.commandset;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.html.HtmlPage;
import org.wetator.backend.ControlFeature;
import org.wetator.backend.IBrowser;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.IFocusable;
import org.wetator.backend.control.KeySequence;
import org.wetator.backend.htmlunit.HtmlUnitBrowser;
import org.wetator.commandset.AbstractCommandSet;
import org.wetator.core.Command;
import org.wetator.core.ICommandImplementation;
import org.wetator.core.Variable;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.exception.CommandException;
import org.wetator.exception.InvalidInputException;
import org.wetator.gui.InputDialog;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.SecretString;

public final class IncubatorCommandSet
extends AbstractCommandSet {
    @Override
    protected void registerCommands() {
        this.registerCommand("assert-focus", new CommandAssertFocus());
        this.registerCommand("save-bookmark", new CommandSaveBookmark());
        this.registerCommand("open-bookmark", new CommandOpenBookmark());
        this.registerCommand("exec-js", new CommandExecJs());
        this.registerCommand("type", new CommandType());
        this.registerCommand("wait", new CommandWait());
        this.registerCommand("enter-variable", new CommandEnterVariable());
    }

    @Override
    public void initialize(Properties aConfiguration) {
    }

    @Override
    public void cleanup() {
    }

    public final class CommandType
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            String tmpKeys = aCommand.getRequiredFirstParameterValue(aContext).getValue();
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            try {
                IControl tmpFocusedControl = tmpBrowser.getFocusedControl();
                tmpBrowser.markControls(tmpFocusedControl);
                tmpFocusedControl.type(aContext, KeySequence.parse(tmpKeys));
                tmpBrowser.saveCurrentWindowToLog(tmpFocusedControl);
            }
            catch (BackendException e) {
                String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
                throw new ActionException(tmpMessage, e);
            }
        }
    }

    public final class CommandExecJs
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpJsString = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            try {
                IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
                if (tmpBrowser instanceof HtmlUnitBrowser) {
                    HtmlUnitBrowser tmpHtmlUnitBrowser = (HtmlUnitBrowser)tmpBrowser;
                    HtmlPage tmpHtmlPage = tmpHtmlUnitBrowser.getCurrentHtmlPage();
                    tmpHtmlPage.executeJavaScript(tmpJsString.getValue());
                    tmpHtmlUnitBrowser.waitForImmediateJobs();
                    tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
                }
            }
            catch (BackendException e) {
                String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
                throw new AssertionException(tmpMessage, e);
            }
        }
    }

    public static final class CommandEnterVariable
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            aCommand.checkNoUnusedThirdParameter(aContext);
            SecretString tmpVariable = aCommand.getRequiredFirstParameterValue(aContext);
            String tmpVariableName = tmpVariable.getValue();
            if (!tmpVariableName.startsWith("$")) {
                throw new InvalidInputException("Variable name has to start with $");
            }
            SecretString tmpHint = aCommand.getSecondParameterValue(aContext);
            String tmpHintText = tmpHint.getValue();
            if (StringUtils.isBlank(tmpHintText)) {
                tmpHintText = "Please enter a value for " + tmpVariableName;
            }
            tmpVariableName = tmpVariableName.substring(1);
            boolean tmpIsSecret = tmpVariableName.startsWith("$");
            try {
                String tmpVariableValue = InputDialog.captureInput(tmpHintText, tmpIsSecret);
                if (tmpIsSecret) {
                    aContext.addVariable(new Variable(tmpVariableName, new SecretString(tmpVariableValue)));
                } else {
                    aContext.addVariable(new Variable(tmpVariableName, tmpVariableValue));
                }
            }
            catch (BackendException e) {
                String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
                throw new AssertionException(tmpMessage, e);
            }
        }
    }

    public final class CommandWait
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            long tmpWaitTime;
            SecretString tmpWaitTimeString = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            try {
                BigDecimal tmpValue = new BigDecimal(tmpWaitTimeString.getValue());
                tmpWaitTime = tmpValue.longValueExact();
            }
            catch (ArithmeticException | NumberFormatException e) {
                String tmpMessage = Messages.getMessage("integerParameterExpected", "wait", tmpWaitTimeString.toString(), "1");
                throw new InvalidInputException(tmpMessage);
            }
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            try {
                Thread.sleep(tmpWaitTime * 1000L);
                tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
            }
            catch (InterruptedException e) {
                String tmpMessage = Messages.getMessage("waitError", new Object[0]);
                throw new ActionException(tmpMessage, e);
            }
        }
    }

    public final class CommandSaveBookmark
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpBookmarkName = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            tmpBrowser.bookmarkPage(tmpBookmarkName.getValue());
        }
    }

    public final class CommandOpenBookmark
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpBookmarkName = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            URL tmpUrl = tmpBrowser.getBookmark(tmpBookmarkName.getValue());
            if (tmpUrl == null) {
                String tmpMessage = Messages.getMessage("unknownBookmark", tmpBookmarkName.getValue());
                throw new ActionException(tmpMessage);
            }
            aContext.informListenersInfo("openUrl", tmpUrl.toString());
            tmpBrowser.openUrl(tmpUrl);
            tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
        }
    }

    public final class CommandAssertFocus
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = IncubatorCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.findControls(ControlFeature.FOCUS, tmpWPath);
            IFocusable tmpControl = (IFocusable)IncubatorCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noHtmlElementFound");
            tmpBrowser.markControls(tmpControl);
            boolean tmpHasFocus = tmpControl.hasFocus(aContext);
            Assert.assertTrue(tmpHasFocus, "elementNotFocused", tmpControl.getDescribingText());
        }
    }
}

