/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.commandset;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.IBrowser;
import org.wetator.backend.control.IControl;
import org.wetator.commandset.AbstractCommandSet;
import org.wetator.core.Command;
import org.wetator.core.ICommandImplementation;
import org.wetator.core.WetatorContext;
import org.wetator.core.searchpattern.ContentPattern;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.CommandException;
import org.wetator.exception.ConfigurationException;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.SecretString;
import org.wetator.util.StringUtil;

public final class SqlCommandSet
extends AbstractCommandSet {
    private static final String DB_NAME_PREFIX = "@";
    private static final Logger LOG = LogManager.getLogger(SqlCommandSet.class);
    private static final String PROPERTY_PREFIX = "wetator.db.";
    private static final String PROPERTY_CONNECTIONS = "wetator.db.connections";
    private static final String PROPERTY_PART_DRIVER = ".driver";
    private static final String PROPERTY_PART_URL = ".url";
    private static final String PROPERTY_PART_USER = ".user";
    private static final String PROPERTY_PART_PASSWORD = ".password";
    private final Map<String, Connection> connections = new HashMap<String, Connection>();
    private String defaultConnectionName;

    @Override
    protected void registerCommands() {
        this.registerCommand("exec-sql", new CommandExecSql());
        this.registerCommand("assert-sql", new CommandAssertSql());
        this.registerCommand("assert-sql-in-content", new CommandAssertSqlInContent());
    }

    @Override
    public void initialize(Properties aConfiguration) {
        String tmpPropConnections = aConfiguration.getProperty(PROPERTY_CONNECTIONS);
        if (StringUtils.isEmpty(tmpPropConnections)) {
            this.addInitializationMessage("No database connections defined (property 'wetator.db.connections' not set).");
            LOG.warn("No database connections defined (property 'wetator.db.connections' not set).");
            return;
        }
        List<String> tmpConnectionNames = StringUtil.extractStrings(tmpPropConnections, ",", 92);
        for (String tmpConnectionName : tmpConnectionNames) {
            if (StringUtils.isEmpty(tmpConnectionName = tmpConnectionName.trim())) continue;
            String tmpDriver = aConfiguration.getProperty(PROPERTY_PREFIX + tmpConnectionName + PROPERTY_PART_DRIVER);
            if (StringUtils.isEmpty(tmpDriver)) {
                LOG.warn("No database driver class specified for connection named '" + tmpConnectionName + "'.");
                throw new ConfigurationException("No database driver class specified for connection named '" + tmpConnectionName + "'.");
            }
            try {
                Class.forName(tmpDriver);
            }
            catch (Exception e) {
                LOG.warn("Error during load of database driver class '" + tmpDriver + "' for connection named '" + tmpConnectionName + "'.", (Throwable)e);
                throw new ConfigurationException("Error during load of database driver class '" + tmpDriver + "' for connection named '" + tmpConnectionName + "' (reason: " + e.toString() + ").");
            }
            String tmpUrl = aConfiguration.getProperty(PROPERTY_PREFIX + tmpConnectionName + PROPERTY_PART_URL);
            String tmpUser = aConfiguration.getProperty(PROPERTY_PREFIX + tmpConnectionName + PROPERTY_PART_USER);
            String tmpPassword = aConfiguration.getProperty(PROPERTY_PREFIX + tmpConnectionName + PROPERTY_PART_PASSWORD);
            try {
                Connection tmpConnection = DriverManager.getConnection(tmpUrl, tmpUser, tmpPassword);
                tmpConnection.setAutoCommit(true);
                this.connections.put(tmpConnectionName, tmpConnection);
                if (null == this.defaultConnectionName) {
                    this.defaultConnectionName = tmpConnectionName;
                }
                if (tmpConnectionName.equals(this.defaultConnectionName)) {
                    this.addInitializationMessage("DB " + tmpConnectionName + " (default): " + tmpUrl);
                    continue;
                }
                this.addInitializationMessage("DB " + tmpConnectionName + ": " + tmpUrl);
            }
            catch (Exception e) {
                LOG.warn("Connection to database '" + tmpUrl + "' for connection named '" + tmpConnectionName + "' failed.", (Throwable)e);
                throw new ConfigurationException("Connection to database '" + tmpUrl + "' for connection named '" + tmpConnectionName + "' failed (reason: " + e.toString() + ").");
            }
        }
    }

    protected String extractConnectionName(WetatorContext aContext, SecretString aParameter) throws InvalidInputException {
        if (aParameter.startsWith(DB_NAME_PREFIX)) {
            for (Map.Entry<String, Connection> tmpEntry : this.connections.entrySet()) {
                String tmpConnectionName = tmpEntry.getKey();
                if (!aParameter.startsWith(tmpConnectionName, 1)) continue;
                return tmpConnectionName;
            }
            aContext.informListenersWarn("undefinedConnectionName", aParameter.toString());
        }
        if (null == this.defaultConnectionName) {
            String tmpMessage = Messages.getMessage("noDefaultConnection", new Object[0]);
            throw new InvalidInputException(tmpMessage);
        }
        return this.defaultConnectionName;
    }

    protected String removeConnectionName(String aSql, String aConnectionName) {
        String tmpConnectionName = DB_NAME_PREFIX + aConnectionName;
        if (aSql.startsWith(tmpConnectionName)) {
            String tmpResult = aSql.substring(tmpConnectionName.length());
            tmpResult = tmpResult.trim();
            return tmpResult;
        }
        return aSql;
    }

    @Override
    public void cleanup() {
        for (Map.Entry<String, Connection> tmpEntry : this.connections.entrySet()) {
            try {
                tmpEntry.getValue().close();
            }
            catch (Exception e) {
                LOG.warn("Error during close of connection to db '" + tmpEntry.getKey() + "'.", (Throwable)e);
            }
        }
        this.defaultConnectionName = null;
        this.connections.clear();
    }

    public final class CommandAssertSqlInContent
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpSqlParam = aCommand.getRequiredFirstParameterValue(aContext);
            Long tmpTimeout = aCommand.getSecondParameterLongValue(aContext);
            if (null == tmpTimeout) {
                tmpTimeout = 0L;
            }
            aCommand.checkNoUnusedThirdParameter(aContext);
            tmpTimeout = Math.max(0L, tmpTimeout);
            tmpSqlParam.trim();
            String tmpConnectionName = SqlCommandSet.this.extractConnectionName(aContext, tmpSqlParam);
            String tmpSql = tmpSqlParam.getValue();
            tmpSql = SqlCommandSet.this.removeConnectionName(tmpSql, tmpConnectionName);
            Connection tmpConnection = (Connection)SqlCommandSet.this.connections.get(tmpConnectionName);
            StringBuilder tmpExpected = new StringBuilder();
            try (Statement tmpStatement = tmpConnection.createStatement();
                 ResultSet tmpResultSet = tmpStatement.executeQuery(tmpSql);){
                ResultSetMetaData tmpMetaData = tmpResultSet.getMetaData();
                while (tmpResultSet.next()) {
                    for (int i = 1; i <= tmpMetaData.getColumnCount(); ++i) {
                        String tmpValue = tmpResultSet.getString(i);
                        if (tmpResultSet.wasNull()) {
                            aContext.informListenersWarn("ignoringNullValue", tmpMetaData.getColumnName(i));
                            continue;
                        }
                        if (tmpExpected.length() > 0) {
                            tmpExpected.append(",").append(' ');
                        }
                        tmpExpected.append(tmpValue);
                    }
                }
            }
            catch (SQLException e) {
                String tmpMessage = Messages.getMessage("sqlFailes", tmpSqlParam.toString(), e.getMessage());
                throw new AssertionException(tmpMessage, e);
            }
            IBrowser tmpBrowser = SqlCommandSet.this.getBrowser(aContext);
            ContentPattern tmpPattern = new ContentPattern(new SecretString(tmpExpected.toString()));
            boolean tmpContentChanged = tmpBrowser.assertContentInTimeFrame(tmpPattern, tmpTimeout);
            if (tmpContentChanged) {
                tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
            }
        }
    }

    public final class CommandAssertSql
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpSqlParam = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            tmpSqlParam.trim();
            String tmpConnectionName = SqlCommandSet.this.extractConnectionName(aContext, tmpSqlParam);
            String tmpSql = tmpSqlParam.getValue();
            tmpSql = SqlCommandSet.this.removeConnectionName(tmpSql, tmpConnectionName);
            Connection tmpConnection = (Connection)SqlCommandSet.this.connections.get(tmpConnectionName);
            StringBuilder tmpResult = new StringBuilder();
            try (Statement tmpStatement = tmpConnection.createStatement();
                 ResultSet tmpResultSet = tmpStatement.executeQuery(tmpSql);){
                ResultSetMetaData tmpMetaData = tmpResultSet.getMetaData();
                while (tmpResultSet.next()) {
                    for (int i = 1; i <= tmpMetaData.getColumnCount(); ++i) {
                        String tmpValue = tmpResultSet.getString(i);
                        if (tmpResultSet.wasNull()) {
                            tmpResult.append("NULL");
                        } else {
                            tmpResult.append(tmpValue);
                        }
                        tmpResult.append(' ');
                    }
                }
            }
            catch (SQLException e) {
                String tmpMessage = Messages.getMessage("sqlFailes", tmpSqlParam.toString(), e.getMessage());
                throw new AssertionException(tmpMessage, e);
            }
            SecretString tmpExpected = aCommand.getRequiredSecondParameterValue(aContext);
            ContentPattern tmpPattern = new ContentPattern(tmpExpected);
            String tmpResultString = tmpResult.toString().trim();
            tmpPattern.matches(tmpResultString, 10000);
        }
    }

    public final class CommandExecSql
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpSqlParam = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            tmpSqlParam.trim();
            String tmpConnectionName = SqlCommandSet.this.extractConnectionName(aContext, tmpSqlParam);
            String tmpSql = tmpSqlParam.getValue();
            tmpSql = SqlCommandSet.this.removeConnectionName(tmpSql, tmpConnectionName);
            Connection tmpConnection = (Connection)SqlCommandSet.this.connections.get(tmpConnectionName);
            try (Statement tmpStatement = tmpConnection.createStatement();){
                tmpStatement.execute(tmpSql);
            }
            catch (SQLException e) {
                String tmpMessage = Messages.getMessage("sqlFailes", tmpSqlParam.toString(), e.getMessage());
                throw new ActionException(tmpMessage);
            }
        }
    }
}

