/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.htmlunit.ScriptPreProcessor;
import org.wetator.backend.IBrowser;
import org.wetator.backend.control.IControl;
import org.wetator.commandset.DefaultCommandSet;
import org.wetator.core.ICommandSet;
import org.wetator.core.IScripter;
import org.wetator.core.Variable;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.exception.ConfigurationException;
import org.wetator.scripter.ExcelScripter;
import org.wetator.scripter.LegacyXMLScripter;
import org.wetator.scripter.WikiTextScripter;
import org.wetator.scripter.XMLScripter;
import org.wetator.util.FileUtil;
import org.wetator.util.SecretString;
import org.wetator.util.StringUtil;

public class WetatorConfiguration {
    private static final Logger LOG = LogManager.getLogger(WetatorConfiguration.class);
    public static final String PROPERTY_PREFIX = "wetator.";
    public static final String PROPERTY_COMMAND_SETS = "wetator.commandSets";
    public static final String PROPERTY_WPATH_SEPARATOR = "wetator.wpath.separator";
    public static final String DEFAULT_WPATH_SEPARATOR = ">";
    public static final String PROPERTY_CONTROLS = "wetator.controls";
    public static final String PROPERTY_SCRIPTERS = "wetator.scripters";
    public static final String PROPERTY_BASE_URL = "wetator.baseUrl";
    public static final String PROPERTY_TYPING_SPEED = "wetator.typingSpeed";
    public static final String PROPERTY_JAVASCRIPT_TIMEOUT = "wetator.jsTimeout";
    public static final String PROPERTY_HTTP_TIMEOUT = "wetator.httpTimeout";
    public static final String PROPERTY_OUTPUT_DIR = "wetator.outputDir";
    private static final String DEFAULT_OUTPUT_DIR = "./logs";
    public static final String PROPERTY_DISTINCT_OUTPUT = "wetator.distinctOutput";
    private static final String DEFAULT_DISTINCT_OUTPUT = "false";
    public static final String PROPERTY_XSL_TEMPLATES = "wetator.xslTemplates";
    public static final String PROPERTY_JS_DEBUGGER = "wetator.jsDebugger";
    public static final String PROPERTY_RETROSPECT = "wetator.retrospect";
    public static final String PROPERTY_BROWSER_TYPE = "wetator.browser";
    private static final IBrowser.BrowserType DEFAULT_BROWSER_TYPE = IBrowser.BrowserType.FIREFOX_ESR;
    public static final String PROPERTY_ACCEPT_LANGUAGE = "wetator.acceptLanguage";
    private static final String DEFAULT_ACCEPT_LANGUAGE = "en-us,en;q=0.8,de-de;q=0.5,de;q=0.3";
    public static final String PROPERTY_BASIC_AUTH_USER = "wetator.basicAuthUser";
    private static final String PROPERTY_BASIC_AUTH_PASSWORD = "wetator.basicAuthPassword";
    public static final String PROPERTY_NTLM_USER = "wetator.ntlmUser";
    private static final String PROPERTY_NTLM_PASSWORD = "wetator.ntlmPassword";
    public static final String PROPERTY_NTLM_WORKSTATION = "wetator.ntlmWorkstation";
    public static final String PROPERTY_NTLM_DOMAIN = "wetator.ntlmDomain";
    public static final String PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_URL = "wetator.clientCertificateKeyStoreUrl";
    public static final String PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_TYPE = "wetator.clientCertificateKeyStoreType";
    public static final String PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_PASSWORD = "wetator.clientCertificateKeyStorePassword";
    public static final String PROPERTY_PROXY_HOST = "wetator.proxyHost";
    public static final String PROPERTY_PROXY_PORT = "wetator.proxyPort";
    public static final String PROPERTY_PROXY_HOSTS_TO_BYPASS = "wetator.proxyHostsToBypass";
    public static final String PROPERTY_PROXY_USER = "wetator.proxyUser";
    private static final String PROPERTY_PROXY_PASSWORD = "wetator.proxyPassword";
    private static final String PROPERTY_JS_JOB_FILTER_FILE = "wetator.jsJobFilterFile";
    public static final String PROPERTY_UPLOAD_MIME_TYPE = "wetator.uploadMimeType";
    public static final String PROPERTY_SCRIPT_PRE_PROCESSOR = "wetator.scriptPreProcessor";
    public static final String VARIABLE_PREFIX = "$";
    public static final String SECRET_PREFIX = "$";
    private static final String WETRESULT_FILE_NAME = "wetresult.xml";
    private static final String WETRESULT_BACKUP_FILE_NAME = "wetresult_back.xml";
    private File sourceFile;
    private File variablesFile;
    private List<IScripter> scripters;
    private List<ICommandSet> commandSets;
    private List<Class<? extends IControl>> controls;
    private String baseUrl;
    private int jsTimeoutInSeconds;
    private int httpTimeoutInSeconds;
    private int typingSpeedInKeystrokesPerMinute;
    private String wpathSeparator;
    private File outputDir;
    private List<String> xslTemplates;
    private List<IBrowser.BrowserType> browserTypes;
    private String acceptLanaguage;
    private SecretString basicAuthUser;
    private SecretString basicAuthPassword;
    private SecretString ntlmUser;
    private SecretString ntlmPassword;
    private SecretString ntlmWorkstation;
    private SecretString ntlmDomain;
    private String proxyHost;
    private int proxyPort;
    private Set<String> proxyHostsToBypass;
    private SecretString proxyUser;
    private SecretString proxyPassword;
    private String clientCertificateKeyStoreUrl;
    private String clientCertificateKeyStoreType;
    private SecretString clientCertificateKeyStorePassword;
    private Set<SearchPattern> jsJobFilterPatterns;
    private boolean jsDebugger;
    private ScriptPreProcessor scriptPreProcessor;
    private Map<String, String> mimeTypes;
    private List<Variable> variables;
    private boolean distinctOutput;
    private boolean appendResults;
    private boolean debugLogging;
    private int retrospect;

    public WetatorConfiguration(File aConfigurationPropertyFile, File aVariablesPropertyFile, Map<String, String> anExternalPropertiesMap) {
        File tmpBaseDirectory;
        Properties tmpProperties;
        LOG.info("Configuration: Configuration file is '" + FilenameUtils.normalize(aConfigurationPropertyFile.getAbsolutePath()) + "'");
        if (!aConfigurationPropertyFile.exists()) {
            throw new ConfigurationException("The configuration file '" + FilenameUtils.normalize(aConfigurationPropertyFile.getAbsolutePath()) + "' does not exist.");
        }
        if (!aConfigurationPropertyFile.canRead()) {
            throw new ConfigurationException("The configuration file '" + FilenameUtils.normalize(aConfigurationPropertyFile.getAbsolutePath()) + "' is not readable.");
        }
        try (InputStream tmpFileInputStream = Files.newInputStream(aConfigurationPropertyFile.toPath(), new OpenOption[0]);){
            tmpProperties = new Properties();
            tmpProperties.load(tmpFileInputStream);
            tmpBaseDirectory = aConfigurationPropertyFile.getParentFile();
            if (null == tmpBaseDirectory) {
                tmpBaseDirectory = new File(System.getProperty("user.dir"));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("An error occured during read of the configuration file '" + aConfigurationPropertyFile.getAbsolutePath() + "'.", e);
        }
        Properties tmpVariablesProperties = new Properties();
        if (aVariablesPropertyFile != null) {
            if (!aVariablesPropertyFile.exists()) {
                throw new ConfigurationException("The variables configuration file '" + FilenameUtils.normalize(aVariablesPropertyFile.getAbsolutePath()) + "' does not exist.");
            }
            if (!aVariablesPropertyFile.canRead()) {
                throw new ConfigurationException("The variables file '" + FilenameUtils.normalize(aVariablesPropertyFile.getAbsolutePath()) + "' is not readable.");
            }
            try (InputStream tmpFileInputStream = Files.newInputStream(aVariablesPropertyFile.toPath(), new OpenOption[0]);){
                tmpVariablesProperties.load(tmpFileInputStream);
            }
            catch (IOException e) {
                throw new ConfigurationException("An error occured during read of the variables file '" + aVariablesPropertyFile.getAbsolutePath() + "'.", e);
            }
        }
        this.sourceFile = aConfigurationPropertyFile;
        this.variablesFile = aVariablesPropertyFile;
        this.initialize(tmpBaseDirectory, tmpProperties, tmpVariablesProperties, anExternalPropertiesMap);
    }

    public WetatorConfiguration(File aBaseDirectory, Properties aConfigurationProperties, Properties aVariablesProperties, Map<String, String> anExternalPropertiesMap) {
        this.initialize(aBaseDirectory, aConfigurationProperties, aVariablesProperties, anExternalPropertiesMap);
    }

    private void initialize(File aBaseDirectory, Properties aConfigurationProperties, Properties aVariablesProperties, Map<String, String> anExternalPropertiesMap) {
        Properties tmpProperties;
        block60: {
            String tmpScriptPreProcessorClassName;
            if (!aBaseDirectory.exists()) {
                throw new ConfigurationException("The base directory '" + FilenameUtils.normalize(aBaseDirectory.getAbsolutePath()) + "' does not exist.");
            }
            if (!aBaseDirectory.isDirectory()) {
                throw new ConfigurationException("The base directory '" + FilenameUtils.normalize(aBaseDirectory.getAbsolutePath()) + "' is not a directory.");
            }
            if (!aBaseDirectory.canRead()) {
                throw new ConfigurationException("The base directory '" + FilenameUtils.normalize(aBaseDirectory.getAbsolutePath()) + "' is not readable.");
            }
            if (!aBaseDirectory.canWrite()) {
                throw new ConfigurationException("The base directory '" + FilenameUtils.normalize(aBaseDirectory.getAbsolutePath()) + "' is not writable.");
            }
            LOG.info("Configuration: Base directory is '" + FilenameUtils.normalize(aBaseDirectory.getAbsolutePath()) + "'");
            tmpProperties = aConfigurationProperties;
            Set<Object> tmpVariablesPropertyNames = aVariablesProperties.keySet();
            for (Object object : tmpVariablesPropertyNames) {
                String string = (String)object;
                if (string.startsWith("$")) {
                    Object tmpPropertyValue = aVariablesProperties.get(string);
                    if (null == tmpPropertyValue) continue;
                    tmpProperties.put(string, tmpPropertyValue);
                    continue;
                }
                LOG.info("Variable property file entry '" + string + "' is not a variable name - entry ignored.");
            }
            Set<Object> tmpSystemPropertyNames = System.getProperties().keySet();
            for (Object object : tmpSystemPropertyNames) {
                String tmpPropertyValue;
                String tmpKeyName = (String)object;
                if (!tmpKeyName.startsWith(PROPERTY_PREFIX) && !tmpKeyName.startsWith("$") || null == (tmpPropertyValue = System.getProperty(tmpKeyName))) continue;
                tmpProperties.put(tmpKeyName, tmpPropertyValue);
            }
            if (null != anExternalPropertiesMap) {
                Set<String> set = anExternalPropertiesMap.keySet();
                for (String tmpKey2 : set) {
                    String string;
                    String tmpKeyName = tmpKey2;
                    if (!tmpKeyName.startsWith(PROPERTY_PREFIX) && !tmpKeyName.startsWith("$") || null == (string = anExternalPropertiesMap.get(tmpKeyName))) continue;
                    tmpProperties.put(tmpKeyName, string);
                }
            }
            this.scripters = new LinkedList<IScripter>();
            this.readScripters(tmpProperties);
            for (IScripter iScripter : this.scripters) {
                iScripter.initialize(tmpProperties);
            }
            this.commandSets = new LinkedList<ICommandSet>();
            this.readCommandSets(tmpProperties);
            for (ICommandSet iCommandSet : this.commandSets) {
                iCommandSet.initialize(tmpProperties);
            }
            this.controls = new LinkedList<Class<? extends IControl>>();
            this.readControls(tmpProperties);
            this.wpathSeparator = tmpProperties.getProperty(PROPERTY_WPATH_SEPARATOR, DEFAULT_WPATH_SEPARATOR);
            String string = tmpProperties.getProperty(PROPERTY_OUTPUT_DIR, DEFAULT_OUTPUT_DIR);
            this.outputDir = new File(string);
            if (!this.outputDir.isAbsolute()) {
                this.outputDir = new File(aBaseDirectory, string);
            }
            String string2 = tmpProperties.getProperty(PROPERTY_DISTINCT_OUTPUT, DEFAULT_DISTINCT_OUTPUT);
            boolean bl = Boolean.parseBoolean(string2);
            LOG.info("Configuration: DistinctOutput is '" + bl + "'");
            if (bl) {
                SimpleDateFormat tmpFormater = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss", Locale.ROOT);
                this.outputDir = new File(this.outputDir, tmpFormater.format(new Date()));
            }
            try {
                FileUtil.createOutputDir(this.outputDir);
            }
            catch (IOException e) {
                throw new ConfigurationException("Could not create output directory '" + FilenameUtils.normalize(this.outputDir.getAbsolutePath()) + "'.", e);
            }
            LOG.info("Configuration: OutputDir is '" + FilenameUtils.normalize(this.outputDir.getAbsolutePath()) + "'");
            String string3 = tmpProperties.getProperty(PROPERTY_BASE_URL, "");
            tmpProperties.remove(PROPERTY_BASE_URL);
            if (StringUtils.isEmpty(string3)) {
                throw new ConfigurationException("The required property 'wetator.baseUrl' is not set.");
            }
            this.baseUrl = string3;
            String string4 = tmpProperties.getProperty(PROPERTY_TYPING_SPEED, "200");
            tmpProperties.remove(PROPERTY_TYPING_SPEED);
            try {
                this.typingSpeedInKeystrokesPerMinute = Integer.parseInt(string4);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("The property 'wetator.typingSpeed' is no integer.");
            }
            String string5 = tmpProperties.getProperty(PROPERTY_JAVASCRIPT_TIMEOUT, "1");
            try {
                this.jsTimeoutInSeconds = Integer.parseInt(string5);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("The property 'wetator.jsTimeout' is no integer.");
            }
            if (this.jsTimeoutInSeconds < 1) {
                throw new ConfigurationException("The property 'wetator.jsTimeout' is less than 1.");
            }
            String string6 = tmpProperties.getProperty(PROPERTY_HTTP_TIMEOUT, "90");
            try {
                this.httpTimeoutInSeconds = Integer.parseInt(string6);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("The property 'wetator.httpTimeout' is no integer.");
            }
            if (this.httpTimeoutInSeconds < 1) {
                throw new ConfigurationException("The property 'wetator.httpTimeout' is less than 1.");
            }
            String string7 = tmpProperties.getProperty(PROPERTY_BROWSER_TYPE, "");
            tmpProperties.remove(PROPERTY_BROWSER_TYPE);
            this.browserTypes = new ArrayList<IBrowser.BrowserType>();
            List<String> tmpParts = StringUtil.extractStrings(string7, ",", 92);
            for (String string8 : tmpParts) {
                if (!StringUtils.isNotBlank(string8)) continue;
                IBrowser.BrowserType tmpBrowserType = IBrowser.BrowserType.getForSymbol(string8);
                if (null == tmpBrowserType) {
                    LOG.warn("Unsupported browser '" + string8 + "'.");
                    continue;
                }
                this.browserTypes.add(tmpBrowserType);
            }
            if (this.browserTypes.isEmpty()) {
                this.browserTypes.add(DEFAULT_BROWSER_TYPE);
            }
            String string9 = tmpProperties.getProperty(PROPERTY_ACCEPT_LANGUAGE, DEFAULT_ACCEPT_LANGUAGE);
            tmpProperties.remove(PROPERTY_ACCEPT_LANGUAGE);
            this.acceptLanaguage = string9;
            String string10 = tmpProperties.getProperty(PROPERTY_PROXY_HOST, "");
            tmpProperties.remove(PROPERTY_PROXY_HOST);
            if (StringUtils.isNotEmpty(string10)) {
                this.proxyHost = string10;
                String string11 = tmpProperties.getProperty(PROPERTY_PROXY_PORT, "");
                tmpProperties.remove(PROPERTY_PROXY_PORT);
                try {
                    this.proxyPort = Integer.parseInt(string11);
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException("The property 'wetator.proxyPort' is no integer.");
                }
                this.proxyHostsToBypass = new HashSet<String>();
                String string12 = tmpProperties.getProperty(PROPERTY_PROXY_HOSTS_TO_BYPASS, "");
                tmpProperties.remove(PROPERTY_PROXY_HOSTS_TO_BYPASS);
                if (StringUtils.isNotBlank(string12)) {
                    String[] tmpNonProxyHostArray = string12.split("\\|");
                    for (String tmpHost : tmpNonProxyHostArray) {
                        if (!StringUtils.isNotBlank(tmpHost)) continue;
                        this.proxyHostsToBypass.add(tmpHost.trim());
                    }
                }
                String string13 = tmpProperties.getProperty(PROPERTY_PROXY_USER, "");
                tmpProperties.remove(PROPERTY_PROXY_USER);
                if (StringUtils.isNotEmpty(string13)) {
                    this.proxyUser = new SecretString(string13);
                    String string14 = tmpProperties.getProperty(PROPERTY_PROXY_PASSWORD, "");
                    tmpProperties.remove(PROPERTY_PROXY_PASSWORD);
                    this.proxyPassword = new SecretString().appendSecret(string14);
                }
            }
            String string15 = tmpProperties.getProperty(PROPERTY_BASIC_AUTH_USER, "");
            tmpProperties.remove(PROPERTY_BASIC_AUTH_USER);
            if (StringUtils.isNotEmpty(string15)) {
                this.basicAuthUser = new SecretString(string15);
                String string16 = tmpProperties.getProperty(PROPERTY_BASIC_AUTH_PASSWORD, "");
                tmpProperties.remove(PROPERTY_BASIC_AUTH_PASSWORD);
                this.basicAuthPassword = new SecretString().appendSecret(string16);
            }
            String string17 = tmpProperties.getProperty(PROPERTY_NTLM_USER, "");
            tmpProperties.remove(PROPERTY_NTLM_USER);
            if (StringUtils.isNotEmpty(string17)) {
                this.ntlmUser = new SecretString(string17);
                String string18 = tmpProperties.getProperty(PROPERTY_NTLM_PASSWORD, "");
                tmpProperties.remove(PROPERTY_NTLM_PASSWORD);
                this.ntlmPassword = new SecretString().appendSecret(string18);
                String string19 = tmpProperties.getProperty(PROPERTY_NTLM_WORKSTATION, "");
                tmpProperties.remove(PROPERTY_NTLM_WORKSTATION);
                this.ntlmWorkstation = new SecretString(string19);
                String string20 = tmpProperties.getProperty(PROPERTY_NTLM_DOMAIN, "");
                tmpProperties.remove(PROPERTY_NTLM_DOMAIN);
                this.ntlmDomain = new SecretString(string20);
            }
            String string21 = tmpProperties.getProperty(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_URL, "");
            tmpProperties.remove(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_URL);
            if (StringUtils.isNotEmpty(string21)) {
                this.clientCertificateKeyStoreUrl = string21;
                String string22 = tmpProperties.getProperty(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_TYPE, "");
                tmpProperties.remove(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_TYPE);
                this.clientCertificateKeyStoreType = string22;
                String string23 = tmpProperties.getProperty(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_PASSWORD, null);
                tmpProperties.remove(PROPERTY_CLIENT_CERTIFICATE_KEY_STORE_PASSWORD);
                this.clientCertificateKeyStorePassword = new SecretString().appendSecret(string23);
            }
            String string24 = tmpProperties.getProperty(PROPERTY_XSL_TEMPLATES, "");
            tmpProperties.remove(PROPERTY_XSL_TEMPLATES);
            this.xslTemplates = new LinkedList<String>();
            tmpParts = StringUtil.extractStrings(string24, ",", 92);
            for (String string25 : tmpParts) {
                if (!StringUtils.isNotBlank(string25)) continue;
                File tmpTemplateFile = new File(string25);
                if (!tmpTemplateFile.isAbsolute()) {
                    tmpTemplateFile = new File(aBaseDirectory, string25);
                }
                if (!tmpTemplateFile.exists()) {
                    throw new ConfigurationException("The configured XSL template '" + FilenameUtils.normalize(tmpTemplateFile.getAbsolutePath()) + "' does not exist.");
                }
                if (!tmpTemplateFile.canRead()) {
                    throw new ConfigurationException("The configured XSL template '" + FilenameUtils.normalize(tmpTemplateFile.getAbsolutePath()) + "' is not readable.");
                }
                this.xslTemplates.add(FilenameUtils.normalize(tmpTemplateFile.getAbsolutePath()));
            }
            String string26 = tmpProperties.getProperty(PROPERTY_JS_JOB_FILTER_FILE, "");
            tmpProperties.remove(PROPERTY_JS_JOB_FILTER_FILE);
            this.jsJobFilterPatterns = new HashSet<SearchPattern>();
            if (StringUtils.isNotBlank(string26)) {
                File tmpFilterFile = new File(string26);
                if (!tmpFilterFile.isAbsolute()) {
                    tmpFilterFile = new File(aBaseDirectory, string26);
                }
                if (!tmpFilterFile.exists()) {
                    throw new ConfigurationException("The configured jsJob filter file '" + FilenameUtils.normalize(tmpFilterFile.getAbsolutePath()) + "' does not exist.");
                }
                if (!tmpFilterFile.canRead()) {
                    throw new ConfigurationException("The configured jsJob filter '" + FilenameUtils.normalize(tmpFilterFile.getAbsolutePath()) + "' is not readable.");
                }
                try {
                    List<String> list = FileUtils.readLines(tmpFilterFile, StandardCharsets.UTF_8);
                    for (String tmpLine : list) {
                        if (!StringUtils.isNotBlank(tmpLine) || tmpLine.charAt(0) == '#') continue;
                        this.jsJobFilterPatterns.add(SearchPattern.compile(tmpLine));
                    }
                }
                catch (IOException iOException) {
                    throw new ConfigurationException("Can't parse jsJob filter file '" + FilenameUtils.normalize(tmpFilterFile.getAbsolutePath()) + "' Reason: " + iOException.getMessage() + ".");
                }
            }
            String string27 = tmpProperties.getProperty(PROPERTY_SCRIPT_PRE_PROCESSOR, "");
            tmpProperties.remove(PROPERTY_SCRIPT_PRE_PROCESSOR);
            if (StringUtils.isNotEmpty(string27) && StringUtils.isNotEmpty(tmpScriptPreProcessorClassName = string27.trim())) {
                Class clazz = null;
                try {
                    Class<?> clazz2;
                    Class<?> tmpScriptPreProzessorClass = clazz2 = Class.forName(tmpScriptPreProcessorClassName);
                    this.scriptPreProcessor = (ScriptPreProcessor)tmpScriptPreProzessorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    LOG.info("Configuration: ScriptPreProzessor '" + tmpScriptPreProcessorClassName + "' registered.");
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.error("Configuration: Can't load scriptPreProzessor '" + tmpScriptPreProcessorClassName + "'.", (Throwable)e);
                    } else {
                        LOG.error("Configuration: Can't load scripPreProzessor '" + tmpScriptPreProcessorClassName + "' (" + e.toString() + ").");
                    }
                }
                catch (ClassCastException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.error("Configuration: Can't load scripPreProzessor '" + tmpScriptPreProcessorClassName + "'.", (Throwable)e);
                    } else {
                        LOG.error("Configuration: Can't load scripPreProzessor '" + tmpScriptPreProcessorClassName + "' (" + e.toString() + ").");
                    }
                    if (null == clazz) break block60;
                    ClassLoader tmpClassLoader = clazz.getClassLoader();
                    LOG.error("         '" + clazz.getName() + "' loaded from " + tmpClassLoader.getResource(clazz.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                    Class<ICommandSet> clazz3 = ICommandSet.class;
                    tmpClassLoader = clazz3.getClassLoader();
                    LOG.error("         '" + clazz3.getName() + "' loaded from " + tmpClassLoader.getResource(clazz3.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                }
            }
        }
        String string = tmpProperties.getProperty(PROPERTY_JS_DEBUGGER, "");
        tmpProperties.remove(PROPERTY_JS_DEBUGGER);
        this.jsDebugger = StringUtils.isNoneBlank(string);
        String string28 = tmpProperties.getProperty(PROPERTY_RETROSPECT, "-1");
        tmpProperties.remove(PROPERTY_RETROSPECT);
        try {
            this.retrospect = Integer.parseInt(string28);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("The property 'wetator.retrospect' is no integer.");
        }
        this.mimeTypes = new HashMap<String, String>();
        Set<Map.Entry<Object, Object>> tmpOtherEntries = tmpProperties.entrySet();
        for (Map.Entry<Object, Object> tmpEntry : tmpOtherEntries) {
            String tmpKey = (String)tmpEntry.getKey();
            if (!tmpKey.startsWith(PROPERTY_UPLOAD_MIME_TYPE)) continue;
            tmpKey = tmpKey.substring(PROPERTY_UPLOAD_MIME_TYPE.length() + 1);
            this.mimeTypes.put(tmpKey, (String)tmpEntry.getValue());
        }
        this.variables = new LinkedList<Variable>();
        tmpOtherEntries = tmpProperties.entrySet();
        for (Map.Entry<Object, Object> tmpEntry : tmpOtherEntries) {
            String tmpKey = (String)tmpEntry.getKey();
            String tmpVariableValue = (String)tmpEntry.getValue();
            if (!tmpKey.startsWith("$")) continue;
            if ((tmpKey = tmpKey.substring(1)).startsWith("$")) {
                this.variables.add(new Variable(tmpKey.substring(1), tmpVariableValue, true));
                continue;
            }
            this.variables.add(new Variable(tmpKey, tmpVariableValue));
        }
        LOG.debug("Configuration: Reading of the configuration finished");
    }

    private void readScripters(Properties aProperties) {
        IScripter tmpDefaultScripter = new XMLScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        tmpDefaultScripter = new LegacyXMLScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        tmpDefaultScripter = new ExcelScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        tmpDefaultScripter = new WikiTextScripter();
        this.scripters.add(tmpDefaultScripter);
        LOG.info("Configuration: Scripter '" + tmpDefaultScripter.getClass().getName() + "' registered.");
        String tmpValue = aProperties.getProperty(PROPERTY_SCRIPTERS, "");
        List<String> tmpScripterClassNames = StringUtil.extractStrings(tmpValue, ",", 92);
        for (String tmpScripterClassName : tmpScripterClassNames) {
            if (StringUtils.isEmpty(tmpScripterClassName = tmpScripterClassName.trim())) continue;
            Class<Object> tmpClass = null;
            try {
                tmpClass = Class.forName(tmpScripterClassName);
                Class<?> tmpScripterClass = tmpClass;
                IScripter tmpIScripter = (IScripter)tmpScripterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.scripters.add(tmpIScripter);
                LOG.info("Configuration: Scripter '" + tmpScripterClassName + "' registered.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "'.", (Throwable)e);
                    continue;
                }
                LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "' (" + e.toString() + ").");
            }
            catch (ClassCastException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "'.", (Throwable)e);
                } else {
                    LOG.error("Configuration: Can't load scripter '" + tmpScripterClassName + "' (" + e.toString() + ").");
                }
                if (null == tmpClass) continue;
                ClassLoader tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                tmpClass = ICommandSet.class;
                tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
            }
        }
    }

    private void readCommandSets(Properties aProperties) {
        String tmpValue = aProperties.getProperty(PROPERTY_COMMAND_SETS, "");
        List<String> tmpCommandSetClassNames = StringUtil.extractStrings(tmpValue, ",", 92);
        tmpCommandSetClassNames.add(0, DefaultCommandSet.class.getName());
        for (String tmpCommandSetClassName : tmpCommandSetClassNames) {
            if (StringUtils.isEmpty(tmpCommandSetClassName = tmpCommandSetClassName.trim())) continue;
            Class<Object> tmpClass = null;
            try {
                tmpClass = Class.forName(tmpCommandSetClassName);
                Class<?> tmpCommandSetClass = tmpClass;
                ICommandSet tmpCommandSet = (ICommandSet)tmpCommandSetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.commandSets.add(tmpCommandSet);
                LOG.info("Configuration: Command set '" + tmpCommandSetClassName + "' registered.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "'.", (Throwable)e);
                    continue;
                }
                LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "' (" + e.toString() + ").");
            }
            catch (ClassCastException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "'.", (Throwable)e);
                } else {
                    LOG.error("Configuration: Can't load command set '" + tmpCommandSetClassName + "' (" + e.toString() + ").");
                }
                if (null == tmpClass) continue;
                ClassLoader tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                tmpClass = ICommandSet.class;
                tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
            }
        }
    }

    private void readControls(Properties aProperties) {
        String tmpValue = aProperties.getProperty(PROPERTY_CONTROLS, "");
        List<String> tmpControlClassNames = StringUtil.extractStrings(tmpValue, ",", 92);
        for (String tmpControlClassName : tmpControlClassNames) {
            if (StringUtils.isEmpty(tmpControlClassName = tmpControlClassName.trim())) continue;
            Class<Object> tmpClass = null;
            try {
                tmpClass = Class.forName(tmpControlClassName);
                Class<?> tmpControlClass = tmpClass;
                this.controls.add(tmpControlClass);
                LOG.info("Configuration: Control '" + tmpControlClassName + "' registered.");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load control '" + tmpControlClassName + "'.", (Throwable)e);
                    continue;
                }
                LOG.error("Configuration: Can't load control '" + tmpControlClassName + "' (" + e.toString() + ").");
            }
            catch (ClassCastException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Configuration: Can't load control '" + tmpControlClassName + "'.", (Throwable)e);
                } else {
                    LOG.error("Configuration: Can't load control '" + tmpControlClassName + "' (" + e.toString() + ").");
                }
                if (null == tmpClass) continue;
                ClassLoader tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
                tmpClass = ICommandSet.class;
                tmpClassLoader = tmpClass.getClassLoader();
                LOG.error("         '" + tmpClass.getName() + "' loaded from " + tmpClassLoader.getResource(tmpClass.getName().replace('.', '/') + ".class").toString() + "' (" + tmpClassLoader.toString() + ").");
            }
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getVariablesFile() {
        return this.variablesFile;
    }

    public List<ICommandSet> getCommandSets() {
        return this.commandSets;
    }

    public List<Class<? extends IControl>> getControls() {
        return this.controls;
    }

    public List<IScripter> getScripters() {
        return this.scripters;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public int getJsTimeoutInSeconds() {
        return this.jsTimeoutInSeconds;
    }

    public int getHttpTimeoutInSeconds() {
        return this.httpTimeoutInSeconds;
    }

    public String getWPathSeparator() {
        return this.wpathSeparator;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public List<IBrowser.BrowserType> getBrowserTypes() {
        return this.browserTypes;
    }

    public boolean startJsDebugger() {
        return this.jsDebugger;
    }

    public String getAcceptLanaguage() {
        return this.acceptLanaguage;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public Set<String> getProxyHostsToBypass() {
        return this.proxyHostsToBypass;
    }

    public SecretString getProxyUser() {
        return this.proxyUser;
    }

    public SecretString getProxyPassword() {
        return this.proxyPassword;
    }

    public SecretString getBasicAuthUser() {
        return this.basicAuthUser;
    }

    public SecretString getBasicAuthPassword() {
        return this.basicAuthPassword;
    }

    public SecretString getNtlmUser() {
        return this.ntlmUser;
    }

    public SecretString getNtlmPassword() {
        return this.ntlmPassword;
    }

    public SecretString getNtlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public SecretString getNtlmDomain() {
        return this.ntlmDomain;
    }

    public String getClientCertificateKeyStoreUrl() {
        return this.clientCertificateKeyStoreUrl;
    }

    public String getClientCertificateKeyStoreType() {
        return this.clientCertificateKeyStoreType;
    }

    public SecretString getClientCertificateKeyStorePassword() {
        return this.clientCertificateKeyStorePassword;
    }

    public File getWetResultFile() {
        return new File(this.getOutputDir(), WETRESULT_FILE_NAME);
    }

    public File getWetResultBackupFile() {
        return new File(this.getOutputDir(), WETRESULT_BACKUP_FILE_NAME);
    }

    public List<String> getXslTemplates() {
        return this.xslTemplates;
    }

    public Set<SearchPattern> getJsJobFilterPatterns() {
        return this.jsJobFilterPatterns;
    }

    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public int getTypingSpeedInKeystrokesPerMinute() {
        return this.typingSpeedInKeystrokesPerMinute;
    }

    public int getRetrospect() {
        return this.retrospect;
    }

    public ScriptPreProcessor getScriptPreProcessor() {
        return this.scriptPreProcessor;
    }

    public boolean isDistinctOutputEnabled() {
        return this.distinctOutput;
    }

    public boolean isAppendResultsEnabled() {
        return this.appendResults;
    }

    public void enableAppendResults() {
        this.appendResults = true;
    }

    public boolean isDebugLoggingEnabled() {
        return this.debugLogging;
    }

    public void enableDebugLogging() {
        this.debugLogging = true;
    }
}

