/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.IBrowser;
import org.wetator.backend.control.IControl;
import org.wetator.core.Command;
import org.wetator.core.ForceExecution;
import org.wetator.core.ICommandImplementation;
import org.wetator.core.Variable;
import org.wetator.core.WetatorConfiguration;
import org.wetator.core.WetatorEngine;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.CommandException;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.SecretString;

public class WetatorContext {
    private static final Logger LOG = LogManager.getLogger(WetatorContext.class);
    public static final String VARIABLE_TESTCASE = "wetator.testcase";
    public static final String VARIABLE_BROWSER = "wetator.browser";
    public static final String VARIABLE_TESTFILE = "wetator.testfile";
    public static final String VARIABLE_BASEURL = "wetator.baseurl";
    private final WetatorEngine engine;
    private final String testCaseName;
    private final File file;
    private final IBrowser.BrowserType browserType;
    private final List<Variable> variables;
    private WetatorContext parentContext;
    private boolean errorOccurred;
    private boolean invalidInput;

    public WetatorContext(WetatorEngine aWetatorEngine, String aTestCaseName, File aFile, IBrowser.BrowserType aBrowserType) {
        this.engine = aWetatorEngine;
        this.testCaseName = aTestCaseName;
        this.file = aFile;
        this.browserType = aBrowserType;
        this.variables = new LinkedList<Variable>();
        this.addVariable(new Variable(VARIABLE_TESTCASE, new SecretString(aTestCaseName)));
        this.addVariable(new Variable(VARIABLE_BROWSER, new SecretString(aBrowserType.getLabel())));
        this.addVariable(new Variable(VARIABLE_TESTFILE, new SecretString(aFile.getName())));
        this.addVariable(new Variable(VARIABLE_BASEURL, new SecretString(this.getConfiguration().getBaseUrl())));
    }

    protected WetatorContext(WetatorContext aContext, File aFile) {
        this(aContext.engine, aContext.testCaseName, aFile, aContext.browserType);
        this.parentContext = aContext;
        this.errorOccurred = aContext.errorOccurred;
    }

    public IBrowser.BrowserType getBrowserType() {
        return this.browserType;
    }

    public WetatorContext createSubContext(File aFile) {
        return new WetatorContext(this, aFile);
    }

    public File getFile() {
        return this.file;
    }

    public IBrowser getBrowser() {
        return this.engine.getBrowser();
    }

    public WetatorConfiguration getConfiguration() {
        return this.engine.getConfiguration();
    }

    public void addVariable(Variable aVariable) {
        this.variables.add(aVariable);
    }

    public List<Variable> getVariables() {
        LinkedList<Variable> tmpResult = new LinkedList<Variable>(this.variables);
        if (null == this.parentContext) {
            tmpResult.addAll(this.getConfiguration().getVariables());
        } else {
            tmpResult.addAll(this.parentContext.getVariables());
        }
        return tmpResult;
    }

    public SecretString replaceVariables(String aStringWithPlaceholders) {
        return new SecretString(aStringWithPlaceholders).replaceVariables(this.getVariables());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        File tmpFile = this.getFile();
        this.engine.informListenersTestFileStart(tmpFile.getAbsolutePath());
        try {
            List<Command> tmpCommands = this.engine.readCommandsFromFile(tmpFile);
            for (Command tmpCommand : tmpCommands) {
                if (this.executeCommand(tmpCommand)) continue;
                this.setInvalidInput(true);
            }
        }
        catch (InvalidInputException e) {
            this.engine.informListenersError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.engine.informListenersTestFileEnd();
        }
        return !this.invalidInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCommand(Command aCommand) {
        block12: {
            this.engine.informListenersExecuteCommandStart(this, aCommand);
            try {
                if (aCommand.isComment()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Comment: '" + aCommand.toPrintableString(this) + "'");
                    }
                    break block12;
                }
                try {
                    if (this.determineAndExecuteCommandImpl(aCommand)) {
                        this.engine.informListenersExecuteCommandSuccess();
                    } else {
                        this.engine.informListenersExecuteCommandIgnored();
                    }
                }
                catch (AssertionException e) {
                    this.engine.informListenersExecuteCommandFailure(e);
                }
                catch (InvalidInputException e) {
                    this.engine.informListenersExecuteCommandError(e);
                    this.setErrorOccurred(true);
                    boolean bl = false;
                    this.engine.informListenersExecuteCommandEnd();
                    return bl;
                }
                catch (Exception e) {
                    this.engine.informListenersExecuteCommandError(e);
                    this.setErrorOccurred(true);
                }
            }
            finally {
                this.engine.informListenersExecuteCommandEnd();
            }
        }
        return true;
    }

    public boolean determineAndExecuteCommandImpl(Command aCommand) throws CommandException, InvalidInputException {
        ICommandImplementation tmpCommandImplementation = this.engine.getCommandImplementationFor(aCommand.getName());
        if (null == tmpCommandImplementation) {
            throw new InvalidInputException(Messages.getMessage("unsupportedCommand", aCommand.getName(), this.getFile().getAbsolutePath(), Integer.toString(aCommand.getLineNo())));
        }
        if (!this.errorOccurred || tmpCommandImplementation.getClass().isAnnotationPresent(ForceExecution.class)) {
            IBrowser tmpBrowser = this.getBrowser();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing '" + aCommand.toPrintableString(this) + "'");
            }
            try {
                tmpCommandImplementation.execute(this, aCommand);
            }
            catch (ActionException e) {
                tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
                tmpBrowser.checkAndResetFailures();
                throw e;
            }
            catch (Error | RuntimeException | CommandException | InvalidInputException e) {
                tmpBrowser.checkAndResetFailures();
                throw e;
            }
            AssertionException tmpFailure = tmpBrowser.checkAndResetFailures();
            if (null != tmpFailure) {
                throw tmpFailure;
            }
            return true;
        }
        return false;
    }

    public void informListenersWarn(String aMessageKey, String ... aParameters) {
        this.informListenersWarn(aMessageKey, aParameters, (String)null);
    }

    public void informListenersWarn(String aMessageKey, String[] aParameters, String aDetails) {
        this.engine.informListenersWarn(aMessageKey, (Object[])aParameters, aDetails);
    }

    public void informListenersWarn(String aMessageKey, String[] aParameters, Throwable aThrowable) {
        this.engine.informListenersWarn(aMessageKey, (Object[])aParameters, aThrowable);
    }

    public void informListenersInfo(String aMessageKey, String ... aParameters) {
        this.engine.informListenersInfo(aMessageKey, aParameters);
    }

    public void informListenersHtmlDocu(String aHtmlDescription) {
        this.engine.informListenersHtmlDescribe(aHtmlDescription);
    }

    private void setErrorOccurred(boolean anErrorOccurred) {
        this.errorOccurred = anErrorOccurred;
        if (this.parentContext != null) {
            this.parentContext.setErrorOccurred(anErrorOccurred);
        }
    }

    public void setInvalidInput(boolean anInvalidInput) {
        this.invalidInput = anInvalidInput;
        if (this.parentContext != null) {
            this.parentContext.setInvalidInput(anInvalidInput);
        }
    }
}

