/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core.searchpattern;

import dk.brics.automaton.RunAutomaton;
import java.util.regex.MatchResult;

public abstract class AbstractAutomatonMatcher
implements MatchResult {
    protected final CharSequence chars;
    protected final RunAutomaton automaton;
    protected int matchStart = -1;
    protected int matchEnd = -1;

    public AbstractAutomatonMatcher(CharSequence aCharSequence, RunAutomaton anAutomaton) {
        this.chars = aCharSequence;
        this.automaton = anAutomaton;
    }

    protected void setMatch(int aMatchStart, int aMatchEnd) {
        if (aMatchStart > aMatchEnd) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + aMatchStart + ", " + aMatchEnd);
        }
        this.matchStart = aMatchStart;
        this.matchEnd = aMatchEnd;
    }

    @Override
    public int end() {
        this.matchGood();
        return this.matchEnd;
    }

    @Override
    public int end(int aGroup) {
        AbstractAutomatonMatcher.onlyZero(aGroup);
        return this.end();
    }

    @Override
    public String group() {
        this.matchGood();
        return this.chars.subSequence(this.matchStart, this.matchEnd).toString();
    }

    @Override
    public String group(int aGroup) {
        AbstractAutomatonMatcher.onlyZero(aGroup);
        return this.group();
    }

    @Override
    public int groupCount() {
        return 0;
    }

    @Override
    public int start() {
        this.matchGood();
        return this.matchStart;
    }

    @Override
    public int start(int aGroup) {
        AbstractAutomatonMatcher.onlyZero(aGroup);
        return this.start();
    }

    private static void onlyZero(int aGroup) {
        if (aGroup != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    private void matchGood() {
        if (this.matchStart < 0 || this.matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }
}

