/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core.searchpattern;

import dk.brics.automaton.RunAutomaton;
import org.wetator.core.searchpattern.AbstractAutomatonMatcher;

public final class AutomatonShortMatcher
extends AbstractAutomatonMatcher {
    public AutomatonShortMatcher(CharSequence aCharSequence, RunAutomaton anAutomaton) {
        this(aCharSequence, 0, anAutomaton);
    }

    public AutomatonShortMatcher(CharSequence aCharSequence, int aStartPos, RunAutomaton anAutomaton) {
        super(aCharSequence, anAutomaton);
        this.matchStart = Math.max(0, aStartPos) - 1;
    }

    public boolean find() {
        int tmpLength;
        if (this.matchStart == -2) {
            return false;
        }
        int tmpBegin = this.matchStart == -1 ? 0 : this.matchStart + 1;
        if (tmpBegin > (tmpLength = this.chars.length())) {
            return false;
        }
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            this.setMatch(tmpBegin, tmpBegin);
            return true;
        }
        int tmpMatchStart = -1;
        while (tmpBegin < tmpLength) {
            int tmpNewState;
            int tmpState = this.automaton.getInitialState();
            for (int i = tmpBegin; i < tmpLength && (tmpNewState = this.automaton.step(tmpState, this.chars.charAt(i))) != -1; ++i) {
                if (this.automaton.isAccept(tmpNewState)) {
                    if (tmpMatchStart == -1) {
                        tmpMatchStart = tmpBegin;
                    }
                    this.setMatch(tmpMatchStart, i + 1);
                    if (this.matchEnd - this.matchStart > 1) {
                        this.reduceIfPossible();
                    }
                    return true;
                }
                tmpState = tmpNewState;
            }
            ++tmpBegin;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void reduceIfPossible() {
        block0: for (int tmpBegin = this.matchStart + 1; tmpBegin < this.matchEnd; ++tmpBegin) {
            int tmpState = this.automaton.getInitialState();
            for (int i = tmpBegin; i < this.matchEnd; ++i) {
                int tmpNewState = this.automaton.step(tmpState, this.chars.charAt(i));
                if (tmpNewState == -1) {
                    return;
                }
                if (this.automaton.isAccept(tmpNewState)) {
                    this.setMatch(tmpBegin, this.matchEnd);
                    continue block0;
                }
                tmpState = tmpNewState;
            }
        }
    }
}

