/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core.searchpattern;

import org.apache.commons.lang3.StringUtils;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public final class TextOnlySearchPattern
extends SearchPattern {
    private final String patternString;
    private final int patternLength;

    protected TextOnlySearchPattern(String anOriginalString, String aPatternString) {
        super(anOriginalString);
        this.patternString = aPatternString;
        this.patternLength = aPatternString.length();
    }

    @Override
    public int getMinLength() {
        return this.patternLength;
    }

    @Override
    public boolean matches(String aString) {
        return this.patternString.equals(aString);
    }

    @Override
    public boolean matchesAtEnd(String aString) {
        if (StringUtils.isEmpty(aString)) {
            return false;
        }
        return aString.endsWith(this.patternString);
    }

    @Override
    public FindSpot firstOccurenceIn(String aString) {
        return this.firstOccurenceIn(aString, 0);
    }

    @Override
    public FindSpot firstOccurenceIn(String aString, int aStartPos) {
        if (StringUtils.isEmpty(aString)) {
            return FindSpot.NOT_FOUND;
        }
        int tmpPos = aString.indexOf(this.patternString, aStartPos);
        if (0 > tmpPos) {
            return FindSpot.NOT_FOUND;
        }
        return new FindSpot(tmpPos, tmpPos + this.patternLength);
    }

    @Override
    public FindSpot lastOccurenceIn(String aString) {
        if (StringUtils.isEmpty(aString)) {
            return FindSpot.NOT_FOUND;
        }
        int tmpPos = aString.lastIndexOf(this.patternString);
        if (0 > tmpPos) {
            return null;
        }
        return new FindSpot(tmpPos, tmpPos + this.patternLength);
    }

    @Override
    public int noOfCharsBeforeLastOccurenceIn(String aString) {
        if (StringUtils.isEmpty(aString)) {
            return -1;
        }
        return aString.lastIndexOf(this.patternString);
    }

    @Override
    public int noOfCharsBeforeLastShortestOccurenceIn(String aString) {
        return this.noOfCharsBeforeLastOccurenceIn(aString);
    }

    @Override
    public int noOfCharsAfterLastOccurenceIn(String aString) {
        if (StringUtils.isEmpty(aString)) {
            return -1;
        }
        int tmpPos = aString.lastIndexOf(this.patternString);
        if (0 > tmpPos) {
            return -1;
        }
        return aString.length() - (tmpPos += this.patternLength);
    }

    @Override
    public int noOfCharsAfterLastShortestOccurenceIn(String aString) {
        return this.noOfCharsAfterLastOccurenceIn(aString);
    }

    @Override
    public int noOfSurroundingCharsIn(String aString) {
        if (StringUtils.isEmpty(aString)) {
            return -1;
        }
        int tmpPos = aString.indexOf(this.patternString);
        if (0 > tmpPos) {
            return -1;
        }
        return aString.length() - this.patternLength;
    }

    public String toString() {
        return "SearchPattern '" + this.getOriginalString() + "' [text: '" + this.patternString + "']";
    }
}

