/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.wetator.exception.BackendException;

public class InputDialog {
    private JDialog dlgInput;
    private LayoutManager layout;
    private JLabel lblInput;
    private JTextField fldInput;
    private JButton btnSubmit;
    private String result;

    public InputDialog() throws BackendException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new BackendException("Using the input dialog is not possible in java headless mode.");
        }
    }

    public static String captureInput(String aHint, boolean aSecretInputFlag) throws BackendException {
        InputDialog tmpHandler = new InputDialog();
        tmpHandler.dlgInput = new JDialog();
        tmpHandler.dlgInput.setModal(true);
        tmpHandler.dlgInput.setAlwaysOnTop(true);
        tmpHandler.layout = new GridBagLayout();
        tmpHandler.lblInput = new JLabel();
        tmpHandler.fldInput = aSecretInputFlag ? new JPasswordField() : new JTextField();
        tmpHandler.btnSubmit = new JButton();
        tmpHandler.addWidgets();
        tmpHandler.handleInput(aHint);
        return tmpHandler.result;
    }

    private void addWidgets() {
        this.dlgInput.getContentPane().setLayout(this.layout);
        GridBagConstraints tmpGBC = new GridBagConstraints();
        tmpGBC.gridx = 0;
        tmpGBC.gridy = 0;
        tmpGBC.anchor = 17;
        tmpGBC.insets.left = 5;
        tmpGBC.insets.right = 5;
        tmpGBC.insets.bottom = 7;
        tmpGBC.insets.top = 15;
        this.dlgInput.getContentPane().add((Component)this.lblInput, tmpGBC);
        tmpGBC.ipady = 7;
        tmpGBC.gridx = 1;
        tmpGBC.insets.bottom = 0;
        tmpGBC.insets.top = 0;
        tmpGBC.fill = 2;
        tmpGBC.insets.top = 7;
        this.dlgInput.getContentPane().add((Component)this.fldInput, tmpGBC);
        tmpGBC.insets.top = 7;
        tmpGBC.ipady = 2;
        tmpGBC.gridx = 0;
        tmpGBC.gridy = 1;
        tmpGBC.gridwidth = 2;
        tmpGBC.fill = 0;
        tmpGBC.anchor = 10;
        tmpGBC.insets.bottom = 5;
        this.dlgInput.getContentPane().add((Component)this.btnSubmit, tmpGBC);
    }

    public void handleInput(String aHint) {
        this.addWidgets();
        this.setEventListeners();
        this.dlgInput.setTitle("Define variable");
        this.lblInput.setText(aHint);
        this.fldInput.setPreferredSize(this.lblInput.getPreferredSize());
        this.btnSubmit.setText("Submit");
        this.dlgInput.pack();
        this.dlgInput.setLocation(this.getDialogLocation().width, this.getDialogLocation().height);
        this.dlgInput.setVisible(true);
    }

    private void setEventListeners() {
        this.btnSubmit.addActionListener(anEvent -> {
            this.result = this.fldInput.getText();
            this.dlgInput.dispose();
        });
        this.fldInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent anEvent) {
                if (anEvent.getKeyCode() == 10) {
                    InputDialog.this.result = InputDialog.this.fldInput.getText();
                    InputDialog.this.dlgInput.dispose();
                }
                if (anEvent.getKeyCode() == 27) {
                    InputDialog.this.dlgInput.dispose();
                }
            }
        });
    }

    private Dimension getDialogLocation() {
        Dimension tmpScreenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension tmpDlgInputDim = this.dlgInput.getSize();
        int tmpDlgInputX = (int)((tmpScreenDim.getWidth() - tmpDlgInputDim.getWidth()) / 2.0);
        int tmpDlgInputY = (int)((tmpScreenDim.getHeight() - tmpDlgInputDim.getHeight()) / 2.0);
        return new Dimension(tmpDlgInputX, tmpDlgInputY);
    }
}

