/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scripter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.OctalUnescaper;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.wetator.core.Command;
import org.wetator.core.IScripter;
import org.wetator.core.Parameter;
import org.wetator.exception.InvalidInputException;
import org.wetator.exception.ResourceException;
import org.wetator.util.NormalizedString;

public final class WikiTextScripter
implements IScripter {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String FILE_EXTENSION = ".wett";
    private static final String COMMENT_LINE = "#";
    private static final String COMMENT_LINE2 = "//";
    private static final String CONTINUATION = "\\";
    private static final String SEPARATOR = "||";
    private static final int COMMAND_NAME_COLUMN_NO = 0;
    private static final int FIRST_PARAM_COLUMN_NO = 1;
    private static final int SECOND_PARAM_COLUMN_NO = 2;
    private static final int THIRD_PARAM_COLUMN_NO = 3;
    private static final CharSequenceTranslator UNESCAPER = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper());
    private File file;
    private List<Command> commands;

    @Override
    public void initialize(Properties aConfiguration) {
    }

    @Override
    public IScripter.IsSupportedResult isSupported(File aFile) {
        String tmpFileName = aFile.getName().toLowerCase(Locale.ROOT);
        if (!tmpFileName.endsWith(FILE_EXTENSION)) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by WikiTextScripter. Extension is not '" + FILE_EXTENSION + "'.");
        }
        if (!aFile.exists() || !aFile.isFile()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by WikiTextScripter. Could not find file.");
        }
        if (!aFile.canRead()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by WikiTextScripter. Could not read file.");
        }
        return IScripter.IS_SUPPORTED;
    }

    @Override
    public void script(File aFile) throws InvalidInputException {
        this.file = aFile;
        this.commands = this.readCommands();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Command> readCommands() throws InvalidInputException {
        LinkedList<Command> tmpResult = new LinkedList<Command>();
        try (LineIterator tmpLines = FileUtils.lineIterator(this.file.getAbsoluteFile(), "UTF-8");){
            int tmpLineNo = 0;
            while (tmpLines.hasNext()) {
                ++tmpLineNo;
                String tmpLine = tmpLines.next().trim();
                while (tmpLine.endsWith(CONTINUATION)) {
                    tmpLine = tmpLine.substring(0, tmpLine.length() - CONTINUATION.length());
                    tmpLine = StringUtils.stripEnd(tmpLine, "\t");
                    tmpLine = tmpLine + NEW_LINE;
                    if (!tmpLines.hasNext()) continue;
                    tmpLine = tmpLine + StringUtils.stripEnd(tmpLines.next(), null);
                    ++tmpLineNo;
                }
                if (StringUtils.isBlank(tmpLine)) continue;
                tmpLine = UNESCAPER.translate(tmpLine);
                boolean tmpComment = false;
                if (tmpLine.startsWith(COMMENT_LINE)) {
                    tmpComment = true;
                    tmpLine = tmpLine.substring(1);
                } else if (tmpLine.startsWith(COMMENT_LINE2)) {
                    tmpComment = true;
                    tmpLine = tmpLine.substring(2);
                }
                String[] tmpParts = StringUtils.splitByWholeSeparator(tmpLine, SEPARATOR);
                String tmpCommandName = "";
                if (tmpParts.length > 0) {
                    tmpCommandName = tmpParts[0];
                    tmpCommandName = tmpCommandName.trim();
                }
                if (StringUtils.isNotEmpty(tmpCommandName) && (!tmpComment || tmpParts.length >= 2)) {
                    tmpCommandName = tmpCommandName.replace(' ', '-').replace('_', '-').toLowerCase(Locale.ROOT);
                }
                tmpCommandName = new NormalizedString(tmpCommandName).toString();
                if (tmpComment && (StringUtils.isEmpty(tmpCommandName) || tmpParts.length < 2)) {
                    tmpCommandName = "comment";
                    if (tmpParts.length == 1) {
                        tmpCommandName = "";
                        tmpParts = new String[]{tmpCommandName, tmpParts[0]};
                    }
                }
                Command tmpCommand = new Command(tmpCommandName, tmpComment);
                String tmpParameter = null;
                if (tmpParts.length > 1) {
                    tmpParameter = tmpParts[1];
                    tmpParameter = tmpParameter.trim();
                }
                if (null != tmpParameter) {
                    tmpCommand.setFirstParameter(new Parameter(tmpParameter));
                }
                tmpParameter = null;
                if (tmpParts.length > 2) {
                    tmpParameter = tmpParts[2];
                    tmpParameter = tmpParameter.trim();
                }
                if (null != tmpParameter) {
                    tmpCommand.setSecondParameter(new Parameter(tmpParameter));
                }
                tmpParameter = null;
                if (tmpParts.length > 3) {
                    tmpParameter = tmpParts[3];
                    tmpParameter = tmpParameter.trim();
                }
                if (null != tmpParameter) {
                    tmpCommand.setThirdParameter(new Parameter(tmpParameter));
                }
                tmpCommand.setLineNo(tmpLineNo);
                tmpResult.add(tmpCommand);
            }
            LinkedList<Command> linkedList = tmpResult;
            return linkedList;
        }
        catch (FileNotFoundException e) {
            throw new InvalidInputException("Could not find file '" + FilenameUtils.normalize(this.file.getAbsolutePath()) + "'.", e);
        }
        catch (IOException e) {
            throw new ResourceException("Could not read file '" + FilenameUtils.normalize(this.file.getAbsolutePath()) + "'.", e);
        }
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }
}

