/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scripter.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wetator.scripter.XMLScripter;
import org.wetator.scripter.xml.XMLSchema;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalEntityResolver
implements EntityResolver {
    private static final Map<String, List<XMLSchema>> KNOWN_SCHEMAS = LocalEntityResolver.getKnownSchemas();
    private static final String XSD_DIRECTORY = "xsd/";
    private File schemaDirectory;

    private static Map<String, List<XMLSchema>> getKnownSchemas() {
        HashMap<String, List<XMLSchema>> tmpKnownSchemas = new HashMap<String, List<XMLSchema>>();
        tmpKnownSchemas.put(XMLScripter.BASE_SCHEMA.getNamespace(), Collections.singletonList(new XMLSchema(XMLScripter.BASE_SCHEMA.getNamespace(), "test-case-1.0.0.xsd")));
        tmpKnownSchemas.put(XMLScripter.DEFAULT_COMMAND_SET_SCHEMA.getNamespace(), Collections.singletonList(new XMLSchema("d", XMLScripter.DEFAULT_COMMAND_SET_SCHEMA.getNamespace(), "default-command-set-1.0.0.xsd")));
        tmpKnownSchemas.put("http://www.wetator.org/xsd/sql-command-set", Collections.singletonList(new XMLSchema("sql", "http://www.wetator.org/xsd/sql-command-set", "sql-command-set-1.0.0.xsd")));
        tmpKnownSchemas.put("http://www.wetator.org/xsd/test-command-set", Collections.singletonList(new XMLSchema("tst", "http://www.wetator.org/xsd/test-command-set", "test-command-set-1.0.0.xsd")));
        tmpKnownSchemas.put("http://www.wetator.org/xsd/incubator-command-set", Collections.singletonList(new XMLSchema("inc", "http://www.wetator.org/xsd/incubator-command-set", "incubator-command-set-1.0.0.xsd")));
        return tmpKnownSchemas;
    }

    public LocalEntityResolver() {
    }

    public LocalEntityResolver(File aSchemaDirectory) {
        this.schemaDirectory = aSchemaDirectory;
    }

    @Override
    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
        InputSource tmpInputSource;
        File tmpSchemaFile;
        List<XMLSchema> tmpKnownSchemaFiles = KNOWN_SCHEMAS.get(aPublicId);
        if (tmpKnownSchemaFiles != null) {
            for (XMLSchema tmpKnownSchemaFile : tmpKnownSchemaFiles) {
                String tmpKnownSchemaFileLocation = tmpKnownSchemaFile.getLocation();
                if (!aSystemId.equals(tmpKnownSchemaFileLocation) && !aSystemId.endsWith("/" + tmpKnownSchemaFileLocation) && !aSystemId.endsWith("\\" + tmpKnownSchemaFileLocation)) continue;
                InputSource tmpInputSource2 = new InputSource(this.getClass().getResourceAsStream(XSD_DIRECTORY + tmpKnownSchemaFileLocation));
                tmpInputSource2.setPublicId(aPublicId);
                tmpInputSource2.setSystemId(this.getClass().getResource(XSD_DIRECTORY + tmpKnownSchemaFileLocation).toExternalForm());
                return tmpInputSource2;
            }
        }
        if (!(tmpSchemaFile = new File(aSystemId)).isAbsolute() && this.schemaDirectory != null) {
            tmpSchemaFile = new File(this.schemaDirectory, tmpSchemaFile.getName());
        }
        if (tmpSchemaFile.exists()) {
            tmpInputSource = new InputSource(tmpSchemaFile.toURI().toURL().toExternalForm());
            tmpInputSource.setPublicId(aPublicId);
            return tmpInputSource;
        }
        try {
            tmpInputSource = new InputSource(new URL(aSystemId).toExternalForm());
            tmpInputSource.setPublicId(aPublicId);
            return tmpInputSource;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

