/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import org.apache.commons.lang3.StringUtils;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.exception.AssertionException;
import org.wetator.i18n.Messages;
import org.wetator.util.SecretString;

public final class Assert {
    private static final String MORE_MARKER = "...";

    private Assert() {
    }

    public static void fail(String aMessageKey, Object ... aParameters) throws AssertionException {
        String tmpMessage = Messages.getMessage(aMessageKey, aParameters);
        throw new AssertionException(tmpMessage);
    }

    public static void assertNotNull(Object anObject, String aMessageKey, Object ... aParameters) throws AssertionException {
        if (null != anObject) {
            return;
        }
        Assert.fail(aMessageKey, aParameters);
    }

    public static void assertNotEmptyOrNull(String aValue, String aMessageKey, Object ... aParameters) throws AssertionException {
        if (StringUtils.isNotEmpty(aValue)) {
            return;
        }
        Assert.fail(aMessageKey, aParameters);
    }

    public static void assertTrue(boolean aCondition, String aMessageKey, Object ... aParameters) throws AssertionException {
        if (aCondition) {
            return;
        }
        Assert.fail(aMessageKey, aParameters);
    }

    public static void assertFalse(boolean aCondition, String aMessageKey, Object ... aParameters) throws AssertionException {
        if (!aCondition) {
            return;
        }
        Assert.fail(aMessageKey, aParameters);
    }

    public static void assertEquals(boolean anExpectedBoolean, boolean aCurrentBoolean, String aMessageKey, Object ... aParameters) throws AssertionException {
        if (anExpectedBoolean == aCurrentBoolean) {
            return;
        }
        Assert.fail(aMessageKey, aParameters);
    }

    public static void assertEquals(String anExpectedString, String aCurrentString, String aMessageKey, Object ... aParameters) throws AssertionException {
        if (anExpectedString == null && aCurrentString == null) {
            return;
        }
        if (anExpectedString != null && anExpectedString.equals(aCurrentString)) {
            return;
        }
        StringBuilder tmpMessage = new StringBuilder(Messages.getMessage(aMessageKey, aParameters)).append(' ').append(Assert.constructComparisonMessage(anExpectedString, aCurrentString));
        throw new AssertionException(tmpMessage.toString());
    }

    public static void assertEquals(SecretString anExpectedString, String aCurrentString, String aMessageKey, Object ... aParameters) throws AssertionException {
        String tmpExpected;
        if ((anExpectedString == null || anExpectedString.getValue() == null) && aCurrentString == null) {
            return;
        }
        if (anExpectedString != null && anExpectedString.getValue() != null && anExpectedString.getValue().equals(aCurrentString)) {
            return;
        }
        StringBuilder tmpMessage = new StringBuilder(Messages.getMessage(aMessageKey, aParameters));
        String tmpCurrent = aCurrentString;
        if (anExpectedString == null) {
            tmpExpected = "null";
        } else if (anExpectedString.getValue() == null) {
            tmpExpected = "null";
            if (tmpCurrent != null && anExpectedString.toString() != null) {
                tmpCurrent = "****";
            }
        } else {
            tmpExpected = anExpectedString.toString();
            if (tmpCurrent != null && !anExpectedString.toString().equals(anExpectedString.getValue())) {
                tmpCurrent = "****";
            }
        }
        tmpMessage.append(' ').append(Assert.constructComparisonMessage(tmpExpected, tmpCurrent));
        throw new AssertionException(tmpMessage.toString());
    }

    private static String constructComparisonMessage(String anExpectedString, String aCurrentString) {
        int k;
        int i;
        if (anExpectedString == null || aCurrentString == null) {
            return Messages.getMessage("assertExpectedActual", anExpectedString, aCurrentString);
        }
        int tmpEnd = Math.min(anExpectedString.length(), aCurrentString.length());
        for (i = 0; i < tmpEnd && anExpectedString.charAt(i) == aCurrentString.charAt(i); ++i) {
        }
        int j = anExpectedString.length() - 1;
        for (k = aCurrentString.length() - 1; k >= i && j >= i && anExpectedString.charAt(j) == aCurrentString.charAt(k); --k, --j) {
        }
        if (j < i && k < i) {
            return Messages.getMessage("assertExpectedActual", anExpectedString, aCurrentString);
        }
        StringBuilder tmpExpected = new StringBuilder();
        StringBuilder tmpCurrent = new StringBuilder();
        int tmpFrom = 0;
        if (i > 4) {
            tmpExpected.append(MORE_MARKER);
            tmpCurrent.append(MORE_MARKER);
            tmpFrom = i;
        }
        if (j + 5 < tmpEnd && k + 5 < tmpEnd) {
            tmpExpected.append(anExpectedString, tmpFrom, j + 1);
            tmpCurrent.append(aCurrentString, tmpFrom, k + 1);
            tmpExpected.append(MORE_MARKER);
            tmpCurrent.append(MORE_MARKER);
        } else {
            tmpExpected.append(anExpectedString.substring(tmpFrom));
            tmpCurrent.append(aCurrentString.substring(tmpFrom));
        }
        return Messages.getMessage("assertExpectedActual", tmpExpected.toString(), tmpCurrent.toString());
    }

    public static void assertMatch(String anExpectedPattern, String aCurrentString, String aMessageKey, Object ... aParameters) throws AssertionException {
        SearchPattern tmpSearchPattern;
        if (anExpectedPattern == null && aCurrentString == null) {
            return;
        }
        if (anExpectedPattern != null && (anExpectedPattern.isEmpty() ? null != aCurrentString && aCurrentString.isEmpty() : (tmpSearchPattern = SearchPattern.compile(anExpectedPattern)).matches(aCurrentString))) {
            return;
        }
        StringBuilder tmpMessage = new StringBuilder(Messages.getMessage(aMessageKey, aParameters)).append(' ').append(Assert.constructComparisonMessage(anExpectedPattern, aCurrentString));
        throw new AssertionException(tmpMessage.toString());
    }
}

