/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public final class FileUtil {
    public static void createOutputDir(File anOutputDir) throws IOException {
        if (null == anOutputDir) {
            throw new IllegalArgumentException("No output directory specified.");
        }
        if (anOutputDir.exists()) {
            if (anOutputDir.isFile()) {
                throw new IOException("There is already a file ('" + FilenameUtils.normalize(anOutputDir.getAbsolutePath()) + "' with the same name as the configured directory. Please change the configured directory or rename the file.");
            }
        } else if (!anOutputDir.mkdirs()) {
            throw new IOException("Can't create the directory ('" + FilenameUtils.normalize(anOutputDir.getAbsolutePath()) + "'. Please change the configuration.");
        }
    }

    private FileUtil() {
    }
}

