/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

public class NormalizedString {
    private static final String BLANK = " ";
    private final StringBuilder content = new StringBuilder();
    private boolean isAppendDisabled;

    public NormalizedString() {
    }

    public NormalizedString(String aString) {
        this();
        this.append(aString);
    }

    public void disableAppend() {
        this.isAppendDisabled = true;
    }

    public void enableAppend() {
        this.isAppendDisabled = false;
    }

    public NormalizedString append(String aString) {
        if (null == aString) {
            return this;
        }
        if (this.isAppendDisabled) {
            return this;
        }
        if (aString.length() < 1) {
            return this;
        }
        boolean tmpBlank = this.content.length() == 0 || this.isWhitespace(this.content.charAt(this.content.length() - 1));
        for (int i = 0; i < aString.length(); ++i) {
            char tmpChar = aString.charAt(i);
            if (this.isWhitespace(tmpChar)) {
                if (tmpBlank) continue;
                tmpBlank = true;
                this.content.append(BLANK);
                continue;
            }
            tmpBlank = false;
            this.content.append(tmpChar);
        }
        return this;
    }

    public NormalizedString append(char[] aChars, int aLength) {
        if (null == aChars) {
            return this;
        }
        if (this.isAppendDisabled) {
            return this;
        }
        if (aLength < 1) {
            return this;
        }
        boolean tmpBlank = this.content.length() == 0 || this.isWhitespace(this.content.charAt(this.content.length() - 1));
        for (int i = 0; i < aLength; ++i) {
            char tmpChar = aChars[i];
            if (this.isWhitespace(tmpChar)) {
                if (tmpBlank) continue;
                tmpBlank = true;
                this.content.append(BLANK);
                continue;
            }
            tmpBlank = false;
            this.content.append(tmpChar);
        }
        return this;
    }

    public NormalizedString appendBlank() {
        boolean tmpBlank;
        if (this.isAppendDisabled) {
            return this;
        }
        boolean bl = tmpBlank = this.content.length() == 0 || this.isWhitespace(this.content.charAt(this.content.length() - 1));
        if (tmpBlank) {
            return this;
        }
        this.content.append(' ');
        return this;
    }

    public String substring(int aStartPos, int anEndPos) {
        int tmpStartPos;
        int tmpLength = this.length();
        if (anEndPos > tmpLength) {
            throw new StringIndexOutOfBoundsException("NormalizedString index out of range: " + anEndPos + " lenght: " + tmpLength + ".");
        }
        if (tmpLength == 0) {
            return "";
        }
        if (aStartPos == anEndPos) {
            return "";
        }
        int tmpEndPos = anEndPos;
        if (this.isWhitespace(this.content.charAt(tmpEndPos - 1))) {
            --tmpEndPos;
        }
        if (this.isWhitespace(this.content.charAt(tmpStartPos = aStartPos))) {
            ++tmpStartPos;
        }
        if (aStartPos == anEndPos) {
            return "";
        }
        return this.content.substring(tmpStartPos, tmpEndPos);
    }

    public int length() {
        int tmpLength = this.content.length();
        if (tmpLength == 0) {
            return tmpLength;
        }
        if (this.isWhitespace(this.content.charAt(this.content.length() - 1))) {
            --tmpLength;
        }
        return tmpLength;
    }

    public String toString() {
        return this.substring(0, this.length());
    }

    private boolean isWhitespace(char aChar) {
        return Character.isWhitespace(aChar) || '\u00a0' == aChar;
    }
}

