/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class StringUtil {
    public static List<String> extractStrings(String aReceiver, String aDelimiter, int anEscapeChar) {
        LinkedList<String> tmpResult = new LinkedList<String>();
        if (null == aReceiver) {
            return tmpResult;
        }
        int tmpSize = aReceiver.length();
        if (tmpSize < 1) {
            return tmpResult;
        }
        int tmpDelimiterSize = aDelimiter.length();
        if (tmpDelimiterSize == 1 && aDelimiter.charAt(0) == anEscapeChar) {
            throw new IllegalArgumentException("Delimiter must be different from escape char.");
        }
        StringBuilder tmpCurrentToken = new StringBuilder();
        for (int tmpIndex = 0; tmpIndex < tmpSize; ++tmpIndex) {
            if (aReceiver.startsWith(aDelimiter, tmpIndex)) {
                tmpResult.add(tmpCurrentToken.toString());
                tmpCurrentToken = new StringBuilder();
                tmpIndex = tmpIndex + tmpDelimiterSize - 1;
                continue;
            }
            char tmpChar = aReceiver.charAt(tmpIndex);
            if (anEscapeChar == tmpChar) {
                if (++tmpIndex < tmpSize) {
                    if (aReceiver.startsWith(aDelimiter, tmpIndex)) {
                        tmpCurrentToken.append(aReceiver.charAt(tmpIndex));
                        continue;
                    }
                    if (anEscapeChar == aReceiver.charAt(tmpIndex)) {
                        tmpCurrentToken.append((char)anEscapeChar);
                        continue;
                    }
                    tmpCurrentToken.append((char)anEscapeChar).append(aReceiver.charAt(tmpIndex));
                    continue;
                }
                tmpCurrentToken.append((char)anEscapeChar);
                continue;
            }
            tmpCurrentToken.append(tmpChar);
        }
        tmpResult.add(tmpCurrentToken.toString());
        return tmpResult;
    }

    public static String formatDate(Date aDate) {
        if (null == aDate) {
            return null;
        }
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", Locale.ROOT).format(aDate);
    }

    public static List<String> split(String aText, int aSize) {
        if (null == aText) {
            return Collections.emptyList();
        }
        int tmpLength = aText.length();
        ArrayList<String> tmpResult = new ArrayList<String>((tmpLength + aSize - 1) / aSize);
        for (int i = 0; i < tmpLength; i += aSize) {
            tmpResult.add(aText.substring(i, Math.min(tmpLength, i + aSize)));
        }
        return tmpResult;
    }

    private StringUtil() {
    }
}

